/**
 * \file: MediaPlaybackStatusChannel.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include <adit_logging.h>
#include "MediaPlaybackStatusChannel.h"
#include "DemoFactory.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

MediaPlaybackStatusChannel::MediaPlaybackStatusChannel(::shared_ptr<GalReceiver> inReceiver,
        uint8_t inSessionId) : mSessionId(inSessionId), mReceiver(inReceiver)
{
    mEndpoint = nullptr;
}

MediaPlaybackStatusChannel::~MediaPlaybackStatusChannel()
{
    mEndpoint = nullptr;
}

void MediaPlaybackStatusChannel::shutdown()
{
    if(mEndpoint != nullptr) {
        mEndpoint->shutdown();
    }
}

bool MediaPlaybackStatusChannel::Initialize()
{
    /* This pointer is deleted at shared_ptr in impl */
    auto creator = DemoFactory::instance().getCreator
            <AditMediaPlaybackStatus, MediaPlaybackStatusCreatorFn>("DummyMediaPlaybackStatus");
    if (creator != nullptr)
    {
        mEndpoint = creator(mSessionId, mReceiver->messageRouter());
    }
    else
    {
        LOG_ERROR((demo, "failed to get creator object"));
        return false;
    }

    if(mEndpoint == nullptr)
    {
        LOG_ERROR((demo, "failed to get output of creator"));
        return false;
    }

    mEndpoint->registerCallbacks(this);

    if(!mEndpoint->init())
    {
        LOG_ERROR((demo, "failed to initialize media playback status endpoint"));
        return false;
    }
    // The argument of API is done const_cast because GalReceiver requires non const pointer.
    if(!mReceiver->registerService(const_cast<AditMediaPlaybackStatus*>(mEndpoint.get())))
    {
        LOG_ERROR((demo, "failed to register media playback status endpoint to receiver"));
        return false;
    }

    return true;
}

int MediaPlaybackStatusChannel::mediaPlaybackReportAction(uint32_t inAction)
{
    LOGD_DEBUG((demo, "%s()  Report Action: %d", __FUNCTION__, inAction));

    return mEndpoint->reportAction(inAction);
}

int MediaPlaybackStatusChannel::mediaPlaybackStatusCallback(struct MediaPlaybackStatusStruct inStatus)
{
    LOGD_DEBUG((demo, "-- Media playback status callback -- Status: %d Source: %s second: %d Shuffle: %d Repeat: %d Repeat one: %d",
                inStatus.state, inStatus.media_source.c_str(), inStatus.playback_seconds,
                inStatus.shuffle, inStatus.repeat, inStatus.repeat_one));

    // TODO:    There is no statement at Google about the expected return value of this callback
    return 0;
}

int MediaPlaybackStatusChannel::mediaPlaybackMetadataCallback(struct MediaPlaybackMetadataStruct inMetadata)
{
    LOGD_DEBUG((demo, "-- Media playback metadata callback -- Song: %s Album: %s Artist: %s Playlist: %s D_Seconds: %u Rating: %d",
                inMetadata.song.c_str(), inMetadata.album.c_str(), inMetadata.artist.c_str(),
                inMetadata.playlist.c_str(), inMetadata.duration_seconds, inMetadata.rating));

    // TODO:    There is no statement at Google about the expected return value of this callback
    return 0;
}

} } /* namespace adit { namespace aauto { */
